package org.msh.etbm.rest.commons;

import java.util.ArrayList;
import java.util.List;

/**
 * Standard REST result from a call. Used throughout the system
 * <p>
 * Created by mauricio on 12/01/18.
 */
public class StandardResult<E> {
    private boolean success;
    private E result;
    private List<ErrorMessage> errors;

    public StandardResult() {
        this.success = true;
    }

    /**
     * Default constructor
     *
     * @param success true if result was succeeded
     * @param result  the result to be serialized
     */
    public StandardResult(boolean success, E result) {
        this.success = success;
        this.result = result;
    }

    public static <E> StandardResult<E> success(E data) {
        return new StandardResult<E>(true, data);
    }

    public static <E> StandardResult<E> failure() {
        return new StandardResult<E>(false, null);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public E getResult() {
        return result;
    }

    public void setResult(E result) {
        this.result = result;
    }

    public List<ErrorMessage> getErrors() {
        return errors;
    }

    public void setErrors(List<ErrorMessage> errors) {
        this.errors = errors;
    }

    public StandardResult<E> addError(ErrorMessage msg) {
        if (this.errors == null) {
            this.errors = new ArrayList<ErrorMessage>();
        }

        errors.add(msg);
        return this;
    }

    public StandardResult<E> addNotNullError(String field) {
        return addFieldError(field, "Valor deve ser informado", "notnull");
    }

    public StandardResult<E> addFieldError(String field, String message, String code) {
        ErrorMessage msg = new ErrorMessage();
        msg.setField(field);
        msg.setMessage(message);
        msg.setCode(code);
        return addError(msg);
    }

    public StandardResult<E> addGlobalError(String message, String code) {
        ErrorMessage msg = new ErrorMessage();
        msg.setCode(code);
        msg.setMessage(message);
        return addError(msg);
    }

    public StandardResult<E> addGlobalErrorMessage(String msg) {
        return addGlobalError(msg, null);
    }

    public StandardResult<E> addGlobalErrorCode(String code) {
        return addGlobalError(null, code);
    }
}
